--
-- Contains helper functions for the OSL maps actionButton actionID's
--
struct OSLHelpers (
	--  Get the current map, in whichever material editor it happens to be....
	fn CurrentMap = 
	(
		if mateditor.mode == #basic then
			medit.GetCurMtl()
		else
			sme.getmtlinparameditor()
	),
	--- Completely generic layering. 
	--- Will search for //====LAYER-BEGIN==== and //====LAYER-END==== in the OSL code
	--- and will add the LAYER(n) macro as many times as the Layers parameter in the OSL Shader
	--- says. It is up to the OSL code to #define, use, and #undef the macro before / after each
	--- section to do whatever is needed to make the dynamic shader work	
	fn UpdateGenericLayering up = 
	(
		local o = CurrentMap()
		
		if (up ==  1 and o.layers < 99) do o.Layers = o.Layers + 1
		if (up == -1 and o.layers >  1) do o.Layers = o.Layers - 1

		-- Since we are editing the source we need to turn off AutoUpdate
		o.OSLAutoUpdate = false
		local s = o.OSLCode
		--- The things searched for in the OSL code
		local startsearch = "//====LAYER-BEGIN===="
		local endsearch   = "//====LAYER-END===="

		-- The part of the string we have already processed
		local processed = ""
		local start = 0
		local end   = 0
	
		start = findString s startsearch
		end  = findString s endsearch
	
		while (start != undefined and end != undefined) do (			
			start = start + startsearch.count			
			before = (substring s 1 start)			
				
			local i = 0
			for i = 1 to o.Layers do
			(
				before = before + "\tLAYER(" + (i as string)  + ")\n" 
			)
			
			-- tuck away whatever we processed in the processed varuable
			processed = processed + before			
			processed = processed + (substring s (end-1) (endsearch.count+1))
			
			-- Set s to rest of string
			s = (substring s (end + endsearch.count) -1)		
			
			-- Search again
			start = findString s startsearch
			end = findString s endsearch
		)		
		-- Add whatever is left in s to processed
		processed = processed + s		
		-- Set the OSL Code to 'processed'
		o.OSLCode = processed
	),	
	--- Gradient need some special sauce
	fn UpdateGradientShader up = 
	(
		local alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ" 
		local o = CurrentMap()
		
		if up == 1  and o.layers < 26 do o.layers = o.layers + 1
		if up == -1 and o.layers > 2 do o.layers = o.layers - 1
		
		o.OSLAutoUpdate = false
		local s = o.OSLCode
		local search = "//====PAR-BEGIN===="
		local start = findString s search
		local end   = findString s "//====PAR-END===="
		if (start > 0) then (
			start = start + search.count
			before = (substring s 1 start)
			local i = 0
			for i = 1 to o.Layers do
			(
				local fraction = (i-1.0) / (o.Layers-1.0)
				local letter = substring alphabet i 1
				before = before + "\tPAR(" + letter + ", " + (fraction as string) + ",  color(" + (abs(cos(i * 15)) as string) + ", " + (abs(sin(i *20)) as string) + ", " + (abs(sin(i*10)) as string) +  "))\n" 
			)
			
			before = before + (substring s (end-1) -1)		
			
			s = before
		)

		search = "//====INT-BEGIN===="
		start = findString s search
		end   = findString s "//====INT-END===="
		if (start > 0) then (
			start = start + search.count
			before = (substring s 1 start)
			local i = 0
			for i = 1 to o.Layers-1 do
			(
				local letter = substring alphabet i 1
				local letter2 = substring alphabet (i+1) 1
				before = before + "\tINT(" + letter + ", " + letter2 + ")\n" 
			)
			
			before = before + (substring s (end-1) -1)		
			
			s = before
		)
		
		o.OSLCode = s
	),
	---- Composite needs some seriously special sauce :)
	fn UpdateCompositeShader up = 
	(
		local o = CurrentMap()
		
		if (up == 1  and o.layers < 50) do o.layers = o.layers + 1
		if (up == -1 and o.layers > 2)  do o.layers = o.layers - 1
		
		o.OSLAutoUpdate = false
		local s = o.OSLCode
		local search = "//====PAR-BEGIN===="
		local start = findString s search
		local end   = findString s "//====PAR-END===="
		if (start > 0) then (
			start = start + search.count
			before = (substring s 1 start)
			local i = 0
			for i = 1 to o.Layers do
			(
				before = before + "\tPAR(" + ((o.Layers - i + 1) as string)  + ")\n" 
			)
			
			before = before + (substring s (end-1) -1)		
			
			s = before
		)

		search = "//====USE-BEGIN===="
		start = findString s search
		end   = findString s "//====USE-END===="
		if (start > 0) then (
			start = start + search.count
			before = (substring s 1 start)
			local i = 0
			for i = 1 to o.Layers do
			(
				before = before + "\tUSE(" + (i as string)  + ")\n" 
			)
			
			before = before + (substring s (end-1) -1)		
			
			s = before
		)
		
		o.OSLCode = s
	),
	--- Helper to swapping stuff in Composite map
	fn SwapProperty o F T = 
	(
		local temp = getProperty o T
		setProperty o T (getProperty o F)
		setProperty o F temp
	),
	--- Swap rows in Composite map
	fn RearrangeCompositeShader n dir = 
	(
		local o = CurrentMap()
		local layers = o.layers	
		local dest = n + dir
		
		if (dest >= 0 and dest <= layers) do
		(
			-- from
			local F = n as string
			-- to
			local T = dest as string 
				
			SwapProperty o ("RGB" + F) ("RGB" + T)
			SwapProperty o ("RGB" + F + "_map") ("RGB" + T + "_map")
			SwapProperty o ("A" + F) ("A" + T)
			SwapProperty o ("A" + F + "_map") ("A" + T + "_map")
			SwapProperty o ("O" + F) ("O" + T)
			SwapProperty o ("O" + F + "_map") ("O" + T + "_map")
			SwapProperty o ("Enable" + F) ("Enable" + T)
			SwapProperty o ("BlendMode" + F) ("BlendMode" + T)
			SwapProperty o ("Premult" + F) ("Premult" + T)
		)	
	),
	--- HDRI Lights special magic
	fn pointHelper p = 
	(
		local o = CurrentMap()
		
		local s = p as string
		-- Point property name
		local pprop = "Pos_" + s
		-- Button property name
		local nprop = "LightHlp" + s

		-- Get the name in the button
		local n = getProperty o nprop

		if (n != undefined) do
		(
			-- See if this is a node
			local myHelper = getNodeByName n
			if (myHelper != undefined) do 
			(
				-- If so, select it, and exit
				select myHelper 
				return 0
			)
		)

		-- Get the current position
		local p = getProperty o pprop
		-- Create a point helper there
		local help = Point pos:p
		-- Set th button text to the name of the thing
		setProperty o nprop help.name
		-- Wire the position to the property
		paramWire.connect help.transform.controller[#Position]  o[pprop] "Position"
		-- Make our point helper selected, so you can start doing "Place Highlight" on it immediately
		select help
	),
	
	--- OBJECT SELECTION STUFF
	
	---
	--- Generic object selection. Populates parameters w. the matrix stuff
	---
	
	fn selectObject msg = 
	(
		local o = CurrentMap()
		o.INode= msg
		local obj = pickObject message:msg
		if (obj != undefined) do (
			o.INode = obj.name
			o.XAxis.controller =  point3_script()
			o.XAxis.controller.addNode "Obj" obj
			o.XAxis.controller.script = "if isValidNode Obj then (coordsys local Obj.transform.row1) else [0,0,0]"
			o.YAxis.controller = point3_script()
			o.YAxis.controller.addNode "Obj" obj
			o.YAxis.controller.script = "if isValidNode Obj then (coordsys local Obj.transform.row2) else [0,0,0]"
			o.ZAxis.controller = point3_script()
			o.ZAxis.controller.addNode "Obj" obj
			o.ZAxis.controller.script = "if isValidNode Obj then (coordsys local Obj.transform.row3) else [0,0,0]"
			o.Position.controller = point3_script()
			o.Position.controller.addNode "Obj" obj
			o.Position.controller.script = "if isValidNode Obj then (coordsys local Obj.transform.row4) else [0,0,0]"
		)
	),
	--- Slightly more specific Camera selection
	fn selectCamera =
	(
		local o = CurrentMap()
		
		o.INode= "Pick a Camera"
		fn camFilt o = (superClassOf o == Camera)
		local obj = pickObject filter:camFilt message:"Pick a Camera"
		if (obj != undefined) do (
			o.INode = obj.name
			o.Camera.controller = point3_script() 
			o.Camera.controller.addNode "Obj" obj
			o.Camera.controller.script = "if isValidNode Obj then Obj.Position else [0,0,0]"
			o.Target.controller = point3_script()
			o.Target.controller.addNode "Obj" obj
			o.Target.controller.script = "if isValidNode Obj then (Obj.Position - Obj.dir) else [0,0,0]"
			o.Right.controller = point3_script()
			o.Right.controller.addNode "Obj" obj
			o.Right.controller.script = "if isValidNode Obj then Obj.transform.Row1 else [0,0,0]"
			local q = float_expression()
			q.addScalarTarget "FOV" obj.baseobject[#fov]
			q.setExpression "FOV"
			o.FOV.controller = q
		)
	)
	,

	fn Reset =  
	(
		local o = CurrentMap()
		OSL.Reset o
	)
)
-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQDBfPy4LhGiTAKpXNKgaBXpQHNkW0sNEBut
-- qoICinAyl0u6WjP2ePsabDdOZzgFQM9xcctsFoto8P2cRpxn3KNvbjY8kSkZ7TDd
-- LxhZ0QvZWzW0cToyu3zvt7211aUgJHeFpQdAd1OSUqowVYUe/7qCV7bjp5CS5iIR
-- nC4L/GWxqwyitoe16nc/CXhvdrqsyEG3bHbzU+T5zSG53fmFxBd1/o1DnCWnBGWW
-- +Tkm7z24Twsv65XTkeUFmGeAOs/zEpLdYK5/5Sr30ribyGPqtzKUFZCAsKoiHMgm
-- ++bd8Osr8UyN+jpsQdnTTUYxZVEJfqAvN0q0JCiAI7bIEh39N+e3
-- -----END-SIGNATURE-----